<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Input Nilai</title>

<style>
    body {
        font-family: Arial, sans-serif;
        background: #f1f1f1;
        margin: 0;
        padding: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        color: #333;
    }

    @media (prefers-color-scheme: dark) {
        body {
            background: #121212;
            color: #eee;
        }
        .card {
            background: #1f1f1f;
        }
        input, select {
            background: #2a2a2a !important;
            color: #fff !important;
            border: 1px solid #555 !important;
        }
        button {
            background: #0d6efd !important;
        }
    }

    .card {
        width: 90%;
        max-width: 450px;
        background: white;
        padding: 30px;
        border-radius: 14px;
        box-shadow: 0 6px 20px rgba(0,0,0,0.2);
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        font-size: 26px;
        font-weight: bold;
    }

    label {
        font-size: 15px;
        font-weight: bold;
        margin-bottom: 6px;
        display: block;
    }

    input, select {
        width: 100%;
        padding: 12px;
        margin-bottom: 20px;
        border-radius: 8px;
        border: 1px solid #ccc;
        font-size: 16px;
    }

    input:focus, select:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 5px rgba(13,110,253,0.4);
    }

    button {
        width: 100%;
        padding: 12px;
        background: #0d6efd;
        color: white;
        border: none;
        border-radius: 8px;
        font-size: 17px;
        cursor: pointer;
        transition: 0.2s;
    }

    button:hover {
        background: #0a58ca;
    }

    .back {
        display: block;
        text-align: center;
        margin-top: 18px;
        color: #555;
        text-decoration: none;
        font-size: 14px;
    }

    .back:hover {
        text-decoration: underline;
    }
</style>

</head>
<body>

<div class="card">

<h2>Input Nilai PAS</h2>

<form action="simpan_nilai.php" method="POST">

    <label>No Peserta:</label>
    <input type="text" name="no_peserta" required>

    <label>Nama Siswa:</label>
    <input type="text" name="nama" required>

    <label>Kelas:</label>
    <select name="kelas" required>
        <option value="">-- Pilih Kelas --</option>
        <option>X RPL</option>
        <option>XI RPL</option>
        <option>XI TKJ A</option>
        <option>XI TKJ B</option>
        <option>XII RPL</option>
        <option>XII TKJ A</option>
        <option>XII TKJ B</option>
    </select>

    <label>Mata Pelajaran:</label>
    <select name="mapel" required>
        <option value="">-- Pilih Mapel --</option>
        <option>Pemrograman Dasar</option>
        <option>Administrasi Sistem Jaringan</option>
        <option>Perenc. dan Pengalamatan Jaringan</option>
        <option>Pemrograman Perangkat Bergerak</option>
        <option>Dasar Desain Grafis</option>
        <option>DDG / UI-UX</option>
    </select>

    <label>Nilai PAS:</label>
    <input type="number" name="nilai_pas" min="0" max="100" required>

    <button type="submit">SIMPAN NILAI</button>
</form>

<a href="data_nilai.php" class="back">Kembali ke Data Nilai</a>

</div>

</body>
</html>
