<?php
require 'config.php';

$id = $_GET['id'];
$stmt = $conn->prepare("SELECT * FROM nilai WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();
$d = $res->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Edit Nilai</title>

<style>
    body {
        font-family: 'Segoe UI', Arial;
        background: #f4f6f9;
        margin: 0;
        padding: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
    }

    @media (prefers-color-scheme: dark) {
        body {
            background: #121212;
            color: #fff;
        }
        .card {
            background: #1f1f1f;
        }
        input, select {
            background: #2b2b2b;
            color: white;
            border: 1px solid #444;
        }
    }

    .card {
        background: white;
        width: 95%;
        max-width: 450px;
        padding: 25px;
        border-radius: 14px;
        box-shadow: 0 6px 18px rgba(0,0,0,0.2);
        animation: fadeIn 0.3s ease-in-out;
    }

    @keyframes fadeIn {
        from {opacity: 0; transform: translateY(20px);}
        to {opacity: 1; transform: translateY(0);}
    }

    h2 {
        text-align: center;
        margin-bottom: 20px;
        font-weight: 600;
        font-size: 24px;
    }

    label {
        font-weight: 600;
        margin-bottom: 5px;
        display: block;
    }

    input, select {
        width: 100%;
        padding: 12px;
        border-radius: 8px;
        border: 1px solid #ccc;
        margin-bottom: 15px;
        font-size: 16px;
    }

    button {
        width: 100%;
        padding: 12px;
        background: #007bff;
        color: white;
        border: none;
        font-size: 17px;
        border-radius: 10px;
        cursor: pointer;
        transition: .2s;
    }

    button:hover {
        background: #0056b3;
    }

    .back {
        display: block;
        text-align: center;
        margin-top: 15px;
        font-size: 15px;
        color: #007bff;
        text-decoration: none;
    }
</style>

</head>
<body>

<div class="card">
    <h2>Edit Nilai PAS</h2>

    <form method="POST" action="update.php">
        <input type="hidden" name="id" value="<?= $d['id'] ?>">

        <label>No Peserta</label>
        <input name="no_peserta" value="<?= $d['no_peserta'] ?>" required>

        <label>Nama</label>
        <input name="nama" value="<?= $d['nama'] ?>" required>

        <label>Kelas</label>
        <select name="kelas" required>
            <option value="">-- Pilih Kelas --</option>
            <?php
            $kelasList = [
                "X RPL ", "XI RPL ",
                "XI TKJ A", "XI TKJ B",
                "XII TKJ A", "XII TKJ B"
            ];
            foreach($kelasList as $k){
                $sel = ($d['kelas'] == $k) ? "selected" : "";
                echo "<option $sel>$k</option>";
            }
            ?>
        </select>

        <label>Mapel</label>
        <select name="mapel" required>
            <option value="">-- Pilih Mapel --</option>
            <?php
            $mapelList = [
                "Pemrograman Dasar",
                "Administrasi Sistem Jaringan",
                "Pemrograman Perangkat Bergerak",
                "Peremc. fan Pengalamatan Jaringan",
                "Dasar Desain Grafis",
                "DDG / UI-UX"
            ];
            foreach($mapelList as $m){
                $sel = ($d['mapel'] == $m) ? "selected" : "";
                echo "<option $sel>$m</option>";
            }
            ?>
        </select>

        <label>Nilai PAS</label>
        <input type="number" name="nilai_pas" value="<?= $d['nilai_pas'] ?>" required>

        <button>Simpan Perubahan</button>
    </form>

    <a href="data_nilai.php" class="back">← Kembali ke Data Nilai</a>
</div>

</body>
</html>
