<?php
require 'config.php';

$no = $_POST['no_peserta'] ?? '';

$stmt = $conn->prepare("SELECT * FROM nilai WHERE no_peserta=? LIMIT 1");
$stmt->bind_param("s", $no);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();
$notfound = !$data;

// Hitung ketuntasan
$q1 = $conn->query("SELECT COUNT(*) AS jml FROM nilai WHERE nilai_pas >= 75");
$tuntas = $q1->fetch_assoc()['jml'];

$q2 = $conn->query("SELECT COUNT(*) AS jml FROM nilai WHERE nilai_pas < 75");
$belum = $q2->fetch_assoc()['jml'];

$total = $tuntas + $belum;

$persen_tuntas = $total > 0 ? round(($tuntas / $total) * 100, 1) : 0;
$persen_belum  = $total > 0 ? round(($belum / $total) * 100, 1) : 0;
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Hasil Nilai PAS</title>

<style>
body {
    font-family: Arial, sans-serif;
    background: #f0f2f5;
    margin: 0;
    padding: 15px;
}

.card {
    background: white;
    max-width: 500px;
    margin: auto;
    padding: 25px;
    border-radius: 14px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.15);
}

h2 {
    text-align: center;
}

.data-box {
    background: #fafafa;
    padding: 15px;
    border-radius: 10px;
    margin-bottom: 15px;
}

.status {
    text-align: center;
    font-size: 20px;
    padding: 12px;
    border-radius: 10px;
    margin-top: 15px;
    font-weight: bold;
}

.tuntas {
    background: #d4edda;
    color: #155724;
    border-left: 5px solid #28a745;
}

.tidaktuntas {
    background: #f8d7da;
    color: #721c24;
    border-left: 5px solid #dc3545;
}

canvas {
    margin-top: 25px;
}

.persen-box {
    margin-top: 15px;
    background: #eef3ff;
    padding: 12px;
    border-radius: 10px;
    text-align: center;
}

/* 🔵 Tombol kembali */
.btn-kembali {
    display: block;
    width: 100%;
    padding: 12px;
    text-align: center;
    background: #0d6efd;
    color: white;
    text-decoration: none;
    border-radius: 8px;
    font-size: 16px;
    margin-top: 25px;
    font-weight: bold;
    transition: 0.25s;
}

.btn-kembali:hover {
    background: #084298;
    transform: scale(1.03);
}
</style>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

</head>
<body>

<div class="card">

<h2>Hasil Cek Nilai PAS</h2>

<?php if ($notfound): ?>

    <p style="text-align:center; color:red; font-weight:bold;">❌ Nomor peserta tidak ditemukan</p>

    <a href="index.html" class="btn-kembali">⬅ Kembali</a>

<?php else: ?>

    <div class="data-box">
        <b>Nama:</b> <?= $data['nama'] ?><br>
        <b>No Peserta:</b> <?= $data['no_peserta'] ?><br>
        <b>Kelas:</b> <?= $data['kelas'] ?><br>
        <b>Mapel:</b> <?= $data['mapel'] ?><br>
        <b>Nilai PAS:</b> <?= $data['nilai_pas'] ?>
    </div>

    <?php if ($data['nilai_pas'] >= 75): ?>
        <div class="status tuntas">
            ✅ TUNTAS — Pertahankan prestasimu!
        </div>
    <?php else: ?>
        <div class="status tidaktuntas">
            ❌ BELUM TUNTAS<br>Anda wajib mengikuti REMEDIAL.<br><small>Tingkatkan belajarmu!</small>
        </div>
    <?php endif; ?>

    <div class="persen-box">
        <b>Persentase Ketuntasan Kelas</b><br><br>
        Tuntas: <b><?= $persen_tuntas ?>%</b><br>
        Belum Tuntas: <b><?= $persen_belum ?>%</b>
    </div>

    <canvas id="grafikTuntas"></canvas>

    <a href="index.html" class="btn-kembali">⬅ Kembali</a>

<?php endif; ?>

</div>

<script>
var tuntas = <?= $tuntas ?>;
var belum = <?= $belum ?>;

new Chart(document.getElementById('grafikTuntas'), {
    type: 'bar',
    data: {
        labels: ['Tuntas', 'Belum Tuntas'],
        datasets: [{
            label: 'Jumlah Siswa',
            data: [tuntas, belum],
            backgroundColor: ['#28a745', '#dc3545'],
            borderColor: ['#1e7e34', '#a71d2a'],
            borderWidth: 2,
            borderRadius: 7
        }]
    },
    options: { scales: { y: { beginAtZero: true } } }
});
</script>

</body>
</html>
